#!/bin/sh
#
#
PROG=ups_monitor
INSTALL_DIR=`pwd`
PROGRAM_DIR=/etc/ups_manager/

echo "SCO UNIX INSTALL FOR ups_manager"
#----------------------------------------------------
#	Must run this script as root
#----------------------------------------------------
uid=`id | sed 's/^uid=\([0-9][0-9]*\).*$/\1/'`
if [ $uid -ne 0 ]; then
    echo "Not logged in as root."
    exit 1
fi

#-------------------------------------------------------
#	Check source files
#----------------------------------------------------
# SendMSG.sh
# TimeCfg.conf
# config
# shutdown.sh
# startup.add
# ups_monitor
# ups_status
#-------------------------------------------------------
if [ ! -s $INSTALL_DIR/ups_monitor ];then
	echo "Missing File Error: $INSTALL_DIR/ups_monitor does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/ups_status ];then
	echo "Missing File Error: $INSTALL_DIR/ups_status does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/ups_config ];then
	echo "Missing File Error: $INSTALL_DIR/ups_config does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/shutdown.sh ];then
	echo "Missing File Error: $INSTALL_DIR/shutdown.sh does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/SendMSG.sh ];then
	echo "Missing File Error: $INSTALL_DIR/SendMSG.sh does not exist."
	exit 2
fi
if [ ! -s $INSTALL_DIR/TimeCfg.conf ];then
        echo "Missing File Error: $INSTALL_DIR/TimeCfg.conf does not exist."
	exit 2
fi

#==============================================================/
#Check and backup previous installation if exists.
#if the previously  installed was found then warnning user and exit the install program.;
#	
#    ==============================================================/

echo "ups_manager will be installed to the directory $PROGRAM_DIR."

if [ -d ${PROGRAM_DIR} ];then

	echo "A previously installed ups_manager was found. Please run then Installation program after stop it and remove it!"
	exit 1
fi
#=========================vicly add this =====================================/
#Start copy  file
#==============================================================/
{
	if [ ! -d $PROGRAM_DIR ]; then
	echo ""
	echo "Create $PROGRAM_DIR directory..."
	mkdir $PROGRAM_DIR
	fi
	cd $PROGRAM_DIR
	echo ""
        echo -n "Moving files from $INSTALL_DIR to $PROGRAM_DIR "
        cp $INSTALL_DIR/ups_monitor $PROGRAM_DIR 2> /dev/null
		if [ $? = 0 ]; then
			echo -n "."
		else
			echo " "
			echo "Please stop the ups_monitor background process and reinstall it."
			echo "Installation not completed!"
	 		exit 0
		fi
        cp $INSTALL_DIR/ups_status $PROGRAM_DIR 2> /dev/null
		if [ $? = 0 ]; then
			echo -n "."
		else
			echo " "
			echo "Please stop the ups_monitor background process and reinstall it."
			echo "Installation not completed!"
	 		exit 0
		fi
        cp $INSTALL_DIR/ups_config $PROGRAM_DIR 2> /dev/null
		if [ $? = 0 ]; then
			echo -n "."
		else
			echo ""
			echo "Please stop the ups_monitor background process and reinstall it."
			echo "Installation not completed!"
	 		exit 0
		fi
        cp $INSTALL_DIR/TimeDfg.conf $PROGRAM_DIR 2> /dev/null
		echo -n "."
        cp $INSTALL_DIR/shutdown.sh $PROGRAM_DIR 2> /dev/null
		echo -n "."
        cp $INSTALL_DIR/Readme $PROGRAM_DIR 2> /dev/null
		echo -n "."
        cp $INSTALL_DIR/ups_manager $PROGRAM_DIR 2> /dev/null
		echo -n "."
        cp $INSTALL_DIR/SendMSG.sh $PROGRAM_DIR 2> /dev/null
		echo -n "."
		cp $INSTALL_DIR/scomsg $PROGRAM_DIR 2> /dev/null
		echo -n "."
		
        echo "OK."
        chmod 544 $PROGRAM_DIR/ups_monitor 2> /dev/null
        chmod 544 $PROGRAM_DIR/ups_status 2> /dev/null
        chmod 544 $PROGRAM_DIR/ups_config 2> /dev/null
		chmod 544 $PROGRAM_DIR/scomsg 2> /dev/null
		chmod 544 $PROGRAM_DIR/ups_manager 2> /dev/null
		
		chmod 744 $PROGRAM_DIR/TimeCfg.conf 2> /dev/null
        chmod 744 $PROGRAM_DIR/shutdown.sh 2> /dev/null
        chmod 744 $PROGRAM_DIR/SendMSG.sh 2> /dev/null
		chmod 644 $PROGRAM_DIR/Readme 2> /dev/null
}
#	=========================vicly add this =====================================/
#	Operation after copy file finished
#	Add the start command into the rc.local ,so it will be  start when the system startup.
#	========================================================================================/

{
echo ""

if [ -s /etc/rc2.d/S98RichManager ]; then
	echo "Backup /etc/rc2.d/S98RichManager to ${INSTALL_DIR}/S98RichManager.old.safemate"
        cp /etc/rc2.d/S98RichManager ${INSTALL_DIR}/S98RichManager.old.safemate
fi
echo -n "Add startup command to /etc/rc2.d..."
grep $PROG /etc/rc2.d/* > /dev/null
if [ $? != 0 ]; then
       cp $INSTALL_DIR/S98RichManager /etc/rc2.d/S98RichManager
       chmod 544 /etc/rc2.d/S98RichManager 2> /dev/null
fi
echo "OK."
echo "Press ENTER to continue..."
read answer
sleep 2
}

#	=========================vicly add this =====================================/
#	Last operate after copy file finished
#	==============================================================/
{
  echo ""
  echo "Configure the parameter."
  sleep 1
  ${PROGRAM_DIR}/ups_config
  sleep 2

echo "Installation completed!"
  echo ""
  echo " Start UPS PowerManager Monitor background process... "

  ${PROGRAM_DIR}/ups_monitor &
}

cd $INSTALL_DIR

sleep 1
exit 0
